﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public enum PanCzyPani {
        [Caption("Pan/Pani")]
        Nieokreślone,
        Pan,
        Pani
    }

    public class Params : ContextBase {

        readonly Nieobecnosc nieobecność;

        public Params(Context context)
            : base(context) {

            nieobecność = (Nieobecnosc)Context[typeof(Nieobecnosc)];
            if (nieobecność.Definicja == null || nieobecność.Definicja.Przyczyna != PrzyczynaNieobecnosci.UrlopWypoczynkowy)
                throw new RowException(nieobecność, "Raport może być drukowany tylko dla nieobecności typu 'Urlop wypoczynkowy'.");

            if (!IsReadOnlyDataZłożeniaWniosku())
                dataZłożeniaWniosku = nieobecność.Okres.From;
        }

        string zastępstwoPełni = "";
        [Priority(10)]
        public string ZastępstwoPełni {
            get { return zastępstwoPełni; }
            set {
                zastępstwoPełni = value;
                UstawPanPani();
                OnChanged(EventArgs.Empty);
            }
        }

        PanCzyPani panPani = PanCzyPani.Nieokreślone;
        [Priority(11)]
        public PanCzyPani PanPani {
            get { return panPani; }
            set {
                panPani = value;
                OnChanged(EventArgs.Empty);
            }
        }

        Date dataZłożeniaWniosku = Date.Empty;
        [Priority(20)]
        public Date DataZłożeniaWniosku {
            get { return dataZłożeniaWniosku; }
            set {
                dataZłożeniaWniosku = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyDataZłożeniaWniosku() {
            return nieobecność.Urlop.Przyczyna != PrzyczynaUrlopu.NaŻądanie;
        }

        void UstawPanPani() {
            string imię = zastępstwoPełni.Trim().Split(' ')[0];
            if (imię.Length == 0)
                panPani = PanCzyPani.Nieokreślone;
            else
                switch (imię[imię.Length - 1]) {
                    case 'a':
                    case 'A':
                        switch (imię.ToLower()) {
                            case "bonawentura":
                            case "barnaba":
                                panPani = PanCzyPani.Pan;
                                break;
                            default:
                                panPani = PanCzyPani.Pani;
                                break;
                        }
                        break;

                    default:
                        switch (imię.ToLower()) {
                            case "ingrid":
                                panPani = PanCzyPani.Pani;
                                break;
                            default:
                                panPani = PanCzyPani.Pan;
                                break;
                        }
                        break;
                }
        }
    }

    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }
    void dc_ContextLoad(object sender, EventArgs e) {
        Nieobecnosc n = (Nieobecnosc)dc[typeof(Nieobecnosc)];
        CzasDni cd = n.Pracownik.Czasy.NormaNie(n.Okres);
        dlNormaDni.EditValue = cd.Dni;
        dlNormaGodz.EditValue = cd.Czas;

        dlLabelNormaDni.EditValue = cd.Dni == 1 ? "dzień" : "dni";
            

        DefinicjaLimitu d = n.Definicja.Limit;        
        LimitNieobecnosci limit = null;
        if (d != null) {
            limit = (LimitNieobecnosci)n.Module.LimNieobecnosci.WgPracownik[n.Pracownik, d].GetPrev(new YearMonth(n.Okres.To).LastDay);
            if (limit != null && limit.Okres.To < n.Okres.From)
                limit = null;
        }

        if (limit == null) {
            dlLimitDni.EditValue = 0;
            dlLimitGodz.EditValue = Time.Zero;
            dlLabelLimitDni.EditValue = "dni";
        }
        else {
            dlLimitDni.EditValue = limit.PozostaloDni;
            dlLimitGodz.EditValue = limit.PozostaloGodz;
            dlLabelLimitDni.EditValue = limit.PozostaloDni == 1 ? "dzień" : "dni";
        }

        if (n.Urlop.Przyczyna == PrzyczynaUrlopu.Planowy)
            dlPodstawaUdzielenia.EditValue = "planem urlopów";
        else if (pars.DataZłożeniaWniosku == Date.Empty)
            dlPodstawaUdzielenia.EditValue = "wnioskiem pracownika z dnia ....................";
        else
            dlPodstawaUdzielenia.EditValue = "wnioskiem pracownika z dnia <strong>" + pars.DataZłożeniaWniosku + "</strong>";

        switch (pars.PanPani) {
            case PanCzyPani.Pan:
                dlZastępstwoPanPani.EditValue = "Pan"; break;
            case PanCzyPani.Pani:
                dlZastępstwoPanPani.EditValue = "Pani"; break;
            default:
                dlZastępstwoPanPani.EditValue = "Pan/Pani"; break;
        }
        if (pars.ZastępstwoPełni == "")
            dlZastępstwoOsoba.EditValue = "............................................................";
        else {
            dlZastępstwoOsoba.EditValue = pars.ZastępstwoPełni;
            dlZastępstwoOsoba.Bold = true;
        }

        DataLabel6.EditValue = GetMiejscowosc(n.PracHistoria);        
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
    
</script>

<HTML>
	<HEAD>
		<title>Tytuł wydruku</title>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="form" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kalend.Nieobecnosc,Soneta.KadryPlace" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="KARTA URLOPU WYPOCZYNKOWEGO" runat="server"></cc1:ReportHeader>
			<P>
				<TABLE id="Table1" cellSpacing="0" width="100%">
					<TR>
						<TD width="60%"></TD>
						<TD>
							<P align="center"><FONT face="Tahoma" size="2"><ea:DataLabel id="DataLabel6" runat="server" Bold="False">
                                <ValuesMap>
                                    <ea:ValuesPair Key="Na żądanie" Value="na żądanie" />
                                    <ea:ValuesPair Key="Planowy" Value="planowego" />
                                </ValuesMap>
                            </ea:DataLabel>
                                , dnia&nbsp;<ea:DataLabel id="DataLabel7" runat="server" DataMember="Context.ActualDate.Actual" Bold="False">
                                    <ValuesMap>
                                        <ea:ValuesPair Key="Na żądanie" Value="na żądanie" />
                                        <ea:ValuesPair Key="Planowy" Value="planowego" />
                                    </ValuesMap>
                                </ea:DataLabel>
                                <br />
                                .....................................................<BR>
									<FONT size="1">miejscowość i data</FONT></FONT></P>
						</TD>
					</TR>
					<TR>
						<TD width="60%"><EM>
								<ea:DataLabel id="DataLabel1" runat="server" DataMember="PracHistoria.Plec" Bold="False">
									<ValuesMap>
										<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
										<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
									</ValuesMap>
								</ea:DataLabel></EM><BR>
							<ea:DataLabel id="DataLabel2" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:DataLabel></TD>
						<TD><BR>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P align="left"><FONT face="Tahoma" size="2"><STRONG>Informacja o korzystaniu z urlopu 
						wypoczynkowego.</STRONG></FONT></P>
			<P align="left"><FONT face="Tahoma" size="2">Ww. korzysta z urlopu wypoczynkowego&nbsp;<ea:DataLabel id="DataLabel3" runat="server" DataMember="Urlop.Przyczyna">
                    <ValuesMap>
                        <ea:ValuesPair Key="Na żądanie" Value="na żądanie" />
                        <ea:ValuesPair Key="Planowy" Value="planowego" />
                    </ValuesMap>
                </ea:DataLabel>
                &nbsp;w 
					okresie od dnia&nbsp;<ea:DataLabel id="DataLabel4" runat="server" DataMember="Okres.From">
                </ea:DataLabel>
                do dnia&nbsp;<ea:DataLabel id="DataLabel5" runat="server" DataMember="Okres.To">
                </ea:DataLabel>
					łącznie&nbsp;<ea:DataLabel id="dlNormaDni" runat="server">
                    </ea:DataLabel><ea:DataLabel id="dlLabelNormaDni" runat="server" Bold="False">
                    </ea:DataLabel>
                (<ea:DataLabel id="dlNormaGodz" runat="server">
                </ea:DataLabel>
                &nbsp;godz.), zgodnie z <ea:DataLabel id="dlPodstawaUdzielenia" runat="server" Bold="False">
                </ea:DataLabel>
                . </FONT></P>
            <p align="left">
                <font face="Tahoma" size="2">Pozostaje do 
					wykorzystania&nbsp;<ea:DataLabel id="dlLimitDni" runat="server">
                    </ea:DataLabel><ea:DataLabel id="dlLabelLimitDni" runat="server" Bold="False">
                    </ea:DataLabel>
                (<ea:DataLabel id="dlLimitGodz" runat="server">
                </ea:DataLabel>
                godz.) urlopu za rok bieżący. Urlop ten 
					należy wykorzystać zgodnie z planem urlopów.
                Podczas urlopu 
					obowiązki osoby urlopowanej pełni
                    <ea:DataLabel id="dlZastępstwoPanPani" runat="server" Bold="False">
                    </ea:DataLabel>
                    <ea:DataLabel id="dlZastępstwoOsoba" runat="server" Bold="False">
                    </ea:DataLabel>.</font>
                </p>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="zgoda przełożonego" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="zgoda osoby zastępującej pracownika" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="podpis pracownika" Width="34"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>

